require("SandboxVars")
table.insert(SandboxVars, {
	options = {
		{ name = "corpseDistribution", title = "Use Corpses Spawning in Vehicles", default = true },
	}
})

local CORPSE_VALUE = 0
local AMBULANCE_MULTIPLIER = 0

local function updateCorpseVars()
    local sv = SandboxVars.GamestaVehicleZones
    if sv and sv.corpseDistribution ~= false then
        CORPSE_VALUE = 7
        AMBULANCE_MULTIPLIER = 49
    end
end

local function isItemsArray(t)
	if type(t) ~= "table" or #t < 2 then return false end
	return type(t[1]) == "string" and type(t[2]) == "number"
end

local function patchItemsArray(items)
	local changed = 0
	for i = 1, #items, 2 do
		local name = items[i]
		local valIndex = i + 1
		if name == "CorpseMale" or name == "CorpseFemale" then
			items[valIndex] = CORPSE_VALUE
			changed = changed + 1
		end
	end
	return changed
end

local function deepPatch(root)
	local seen = {}
	local total = 0
	local function walk(t, path)
		if type(t) ~= "table" or seen[t] then return end
		seen[t] = true
		local path_lower = (path and path:lower()) or ""
		if isItemsArray(t) and path_lower:find("seat", 1, true) then
			total = total + patchItemsArray(t)
		end
		local items = rawget(t, "items")
		if type(items) == "table" and isItemsArray(items) and path_lower:find("seat", 1, true) then
			total = total + patchItemsArray(items)
		end
		for k, v in pairs(t) do
			if type(v) == "table" then
				local keystr = tostring(k)
				local newpath
				if path and path ~= "" then
					newpath = path .. "." .. keystr
				else
					newpath = keystr
				end
				walk(v, newpath)
			end
		end
	end
	walk(root, "")
	return total
end

local function multiplyAmbulanceTrunkCorpse()
	if VehicleDistributions and VehicleDistributions.AmbulanceTruckBed and VehicleDistributions.AmbulanceTruckBed.junk and isItemsArray(VehicleDistributions.AmbulanceTruckBed.junk.items) then
		local items = VehicleDistributions.AmbulanceTruckBed.junk.items
		local changed = 0
		for i = 1, #items, 2 do
			if items[i] == "CorpseMale" or items[i] == "CorpseFemale" then
				items[i+1] = items[i+1] * AMBULANCE_MULTIPLIER
				changed = changed + 1
			end
		end
	end
end

local function runPatch(phase)
	updateCorpseVars()
	local changed = 0
	if _G.ClutterTables then
		changed = changed + deepPatch(_G.ClutterTables)
	end
	if _G.VehicleDistributions then
		changed = changed + deepPatch(_G.VehicleDistributions)
	end
	multiplyAmbulanceTrunkCorpse()
end

Events.OnPreDistributionMerge.Add(function() runPatch("pre") end)
if Events.OnPostDistributionMerge then
	Events.OnPostDistributionMerge.Add(function() runPatch("post") end)
end
Events.OnInitGlobalModData.Add(function() runPatch("OnInitGlobalModData") end)
